﻿Imports System.IO
Imports System.Data
Imports MySql.Data.MySqlClient

Public Partial Class MainForm
	Public Sub New()
		Me.InitializeComponent()
    End Sub

    Private Enum CurrentProcessType
        Export
        Import
        None
    End Enum

    Private WithEvents mb As MySqlBackup
    Private HighTimeForGuiRefresh As Boolean = True
    Private cpt As CurrentProcessType = CurrentProcessType.None

    Private Function DoConnectionString(Optional ByVal databaseName As String = Nothing) As String
        Dim result As String = Nothing
        Dim newServer As String() = Nothing

        ''check to see if a port was specified
        If Me.txDbServer.Text.Contains(":") = True Then
            newServer = Me.txDbServer.Text.Split(New Char() {":"c}, StringSplitOptions.RemoveEmptyEntries)
            If UBound(newServer) = 1 Then
                result = "server=" & newServer(0) & ";"
                result = "port=" & CInt(newServer(1)) & ";"
            Else
                result = "server=" & Me.txDbServer.Text & ";"
            End If
        Else
            result = "server=" & Me.txDbServer.Text & ";"
        End If

        result += "user=" & Me.txDbUsername.Text & ";"
        result += "pwd=" & Me.txDbPass.Text & ";"

        If databaseName = Nothing Then
            result += "database=" & Me.txDbName.Text & ";"
        Else
            result += "database=" & databaseName & ";"
        End If

        Return result
    End Function

    Private Sub MainFormLoad(ByVal sender As Object, ByVal e As EventArgs) Handles MyBase.Load
        txDbServer.Text = Settings.GetSetting("DbServer")
        txDbName.Text = Settings.GetSetting("DbName")
        txDbUsername.Text = Settings.GetSetting("DbUsername")
        txDbPass.Text = Settings.GetSetting("DbPass")
    End Sub

    Private Sub butInstallClick(ByVal sender As Object, ByVal e As EventArgs) Handles butInstall.Click
        If MsgBox("Are you sure you want to install the database?" & Environment.NewLine & "If the database already exists, it will be overwritten!", _
         MsgBoxStyle.OkCancel, "Install Database") = _
         Windows.Forms.DialogResult.OK Then

            logwind.Items.Clear()

            Settings.SetSetting("DbServer", txDbServer.Text)
            Settings.SetSetting("DbName", txDbName.Text)
            Settings.SetSetting("DbUsername", txDbUsername.Text)
            Settings.SetSetting("DbPass", txDbPass.Text)

            ''we connect to mysql database to avoid the database doesn't exist exception
            Dim dbConnection As MySqlConnectionStringBuilder = New MySqlConnectionStringBuilder(DoConnectionString("mysql"))
            Dim conn1 As New MySqlConnection(dbConnection.ConnectionString)

            Dim myCommand As MySqlCommand = Nothing

            ''drop the old database if exists
            Dim sql As String = "DROP DATABASE IF EXISTS " & Me.txDbName.Text & ";"
            ''create the database if not exists
            sql += "CREATE DATABASE IF NOT EXISTS " & Me.txDbName.Text & ";"

            Dim result As Integer = 0

            Try
                If conn1.State = ConnectionState.Closed Then
                    conn1.Open()
                End If

                myCommand = New MySqlCommand(Sql, conn1)
                result = myCommand.ExecuteNonQuery()

            Catch ex As MySqlException
                Me.logwind.Items.Add(ex.Message & " (" & Sql & ")")
            Finally
                conn1.Close()
                conn1.Dispose()
                myCommand.Dispose()
                dbConnection = Nothing
                sql = Nothing
            End Try

            If result = 1 Then
                Me.logwind.Items.Add("The database was created successfully...")
                Me.logwind.Items.Add("Creating database tables and inserting records...")

                If Not mb Is Nothing Then
                    Me.logwind.Items.Add("Error. Can't start database restore while another process is in progress.")
                    Exit Sub
                End If

                Dim fn As String = Application.StartupPath & "/Sql/database.sql"

                ProgressBar1.Value = 0
                mb = New MySqlBackup()

                mb.Connection = New MySqlConnection(DoConnectionString)
                mb.ImportInfo.AsynchronousMode = True
                mb.ImportInfo.FileName = fn

                AddHandler mb.ImportProgressChanged, AddressOf mb_ImportProgressChanged
                AddHandler mb.ImportCompleted, AddressOf mb_ImportCompleted

                cpt = CurrentProcessType.Import

                ResetButtons()

                Try
                    mb.Import()
                    RefreshTimer.Start()
                Catch ex As Exception
                    RefreshTimer.Stop()
                    Me.logwind.Items.Add("Error occured while starting restore process: " & ex.Message)
                    ClearOperationData(True)
                End Try

            End If

        Else
            Me.logwind.Items.Add("Install process cancelled by user!")
        End If

    End Sub

    Private Sub BSaveClick(ByVal sender As Object, ByVal e As EventArgs) Handles bSave.Click
        Settings.SetSetting("DbServer", txDbServer.Text)
        Settings.SetSetting("DbName", txDbName.Text)
        Settings.SetSetting("DbUsername", txDbUsername.Text)
        Settings.SetSetting("DbPass", txDbPass.Text)

        Me.Close()
    End Sub

    Private Sub ButBackupClick(ByVal sender As Object, ByVal e As EventArgs) Handles butBackup.Click
        If Not mb Is Nothing Then
            MsgBox("Error. Can't start export while another process is in progress.", _
                MsgBoxStyle.Exclamation, "")
            Exit Sub
        End If

        Dim fn As String = Application.StartupPath & "/Backup/" & DateTime.Now.ToString("yyyyMMdd HHmmss") & ".sql"

        ProgressBar1.Value = 0

        mb = New MySqlBackup()

        mb.Connection = New MySqlConnection(DoConnectionString())
        mb.ExportInfo.FileName = fn
        mb.ExportInfo.AsynchronousMode = True

        AddHandler mb.ExportProgressChanged, AddressOf mb_ExportProgressChanged
        AddHandler mb.ExportCompleted, AddressOf mb_ExportCompleted

        cpt = CurrentProcessType.Export

        ResetButtons()

        Try
            mb.Export()
            RefreshTimer.Start()
        Catch ex As Exception
            RefreshTimer.Stop()
            Me.logwind.Items.Add("Error occured while starting export process: " & ex.Message)
            ClearOperationData(True)
        End Try
    End Sub

    Private Sub ButRestoreClick(ByVal sender As Object, ByVal e As EventArgs) Handles butRestore.Click
        With openFileDialog1
            .InitialDirectory = Application.StartupPath & "\Backup"
            .DefaultExt = ".sql"
            .Filter = "SQL (Structured Query Language) file (*.sql)|*.sql"
            .Title = "Select backup file..."
        End With

        If openFileDialog1.ShowDialog() = DialogResult.OK Then
            If MsgBox("Are you sure you want to restore the database? All data will be overwritten!", _
             MsgBoxStyle.OkCancel, "Restore Database?") = _
             Windows.Forms.DialogResult.OK Then

                logwind.Items.Clear()

                If Not mb Is Nothing Then
                    Me.logwind.Items.Add("Error. Can't start database restore while another process is in progress.")
                    Exit Sub
                End If

                Dim fn As String = openFileDialog1.FileName
                ProgressBar1.Value = 0
                mb = New MySqlBackup()

                mb.Connection = New MySqlConnection(DoConnectionString)
                mb.ImportInfo.AsynchronousMode = True
                mb.ImportInfo.FileName = fn

                AddHandler mb.ImportProgressChanged, AddressOf mb_ImportProgressChanged
                AddHandler mb.ImportCompleted, AddressOf mb_ImportCompleted

                cpt = CurrentProcessType.Import

                ResetButtons()

                Try
                    mb.Import()
                    RefreshTimer.Start()
                Catch ex As Exception
                    RefreshTimer.Stop()
                    Me.logwind.Items.Add("Error occured while starting restore process: " & ex.Message)
                    ClearOperationData(True)
                End Try

            End If
        End If
    End Sub

    Private Sub ButCheckConnectionClick(ByVal sender As Object, ByVal e As EventArgs) Handles butCheckConnection.Click
        logwind.Items.Clear()

        ''we connect to mysql database to avoid the database doesn't exist exception
        Dim dbConnection As MySqlConnectionStringBuilder = New MySqlConnectionStringBuilder(DoConnectionString("mysql"))
        Dim conn1 As New MySqlConnection(dbConnection.ConnectionString)

        Dim result As Integer = 0

        Try
            If conn1.State = ConnectionState.Closed Then
                conn1.Open()
                If conn1.Ping = True Then
                    Me.logwind.Items.Add("OK: MySQL server is running.")

                    conn1.Close()
                    conn1.Dispose()

                    dbConnection = Nothing
                    dbConnection = New MySqlConnectionStringBuilder(DoConnectionString())
                    conn1 = New MySqlConnection(dbConnection.ConnectionString)

                    Try
                        If conn1.State = ConnectionState.Closed Then
                            conn1.Open()
                            If conn1.Ping = True Then
                                Me.logwind.Items.Add("OK: Selected database exists.")
                            Else
                                Me.logwind.Items.Add("WARNING: Selected database doesn't exists. Press Install database button to create it!")
                            End If
                        End If
                    Catch ex As Exception
                        Me.logwind.Items.Add("ERROR: " & ex.Message)
                        Me.logwind.Items.Add("WARNING: Selected database doesn't exists. Press Install database button to create it!")
                    End Try

                Else
                    Me.logwind.Items.Add("ERROR: MySQL server is not running on selected host/port.")
                End If
            End If

        Catch ex As MySqlException
            Me.logwind.Items.Add("ERROR: " & ex.Message)
        Finally
            conn1.Close()
            conn1.Dispose()
            dbConnection = Nothing
        End Try
    End Sub

    Private Sub btCancel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btCancel.Click
        If mb Is Nothing OrElse cpt = CurrentProcessType.None Then Exit Sub

        RefreshTimer.Stop()
        Me.btCancel.Enabled = False

        If cpt = CurrentProcessType.Export Then
            Me.logwind.Items.Add("Canceling backup process...")
            mb.CancelExport()
        ElseIf cpt = CurrentProcessType.Import Then
            Me.logwind.Items.Add("Canceling restore process...")
            mb.CancelImport()
        End If
    End Sub

    Private Sub RefreshTimer_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RefreshTimer.Tick
        RefreshTimer.Stop()
        If mb Is Nothing Then Exit Sub
        HighTimeForGuiRefresh = True
        RefreshTimer.Start()
    End Sub

    Private Sub mb_ExportCompleted(ByVal sender As Object, ByVal e As ExportCompleteArg)
        ReportExportCompleted(e)
    End Sub

    Private Delegate Sub ReportExportCompletedInvoker(ByVal e As ExportCompleteArg)
    Private Sub ReportExportCompleted(ByVal e As ExportCompleteArg)

        If Me.InvokeRequired Then
            Me.Invoke(New ReportExportCompletedInvoker(AddressOf ReportExportCompleted), New Object() {e})
            Exit Sub
        End If

        RefreshTimer.Stop()

        If e.CompletedType = ExportCompleteArg.CompleteType.Cancelled Then
            Me.logwind.Items.Add("Backup process was canceled.")
        ElseIf e.CompletedType = ExportCompleteArg.CompleteType.Error Then
            Me.logwind.Items.Add("Backup process was interrupted by an exception.")
        End If

        Dim errMsg As String = ""
        If e.Error IsNot Nothing Then errMsg = e.Error.ToString()
        Me.logwind.Items.Add(("Export " & e.CompletedType.ToString() & vbCrLf & errMsg).Trim)

        ClearOperationData(True)

    End Sub

    Private Sub mb_ExportProgressChanged(ByVal sender As Object, ByVal e As ExportProgressArg)
        ReportExportProgress(e)
    End Sub

    Private Delegate Sub ReportExportProgressInvoker(ByVal e As ExportProgressArg)
    Private Sub ReportExportProgress(ByVal e As ExportProgressArg)

        If Not HighTimeForGuiRefresh AndAlso e.PercentageCompleted < 99 Then Exit Sub

        If Me.InvokeRequired Then
            Me.Invoke(New ReportExportProgressInvoker(AddressOf ReportExportProgress), New Object() {e})
            Exit Sub
        End If

        ProgressBar1.Value = e.PercentageCompleted
        Me.Text = "Progress " + e.PercentageCompleted.ToString() + "%"

        HighTimeForGuiRefresh = False

    End Sub

    Private Sub mb_ImportCompleted(ByVal sender As Object, ByVal e As ImportCompleteArg)
        ReportImportCompleted(e)
    End Sub

    Private Delegate Sub ReportImportCompletedInvoker(ByVal e As ImportCompleteArg)
    Private Sub ReportImportCompleted(ByVal e As ImportCompleteArg)

        If Me.InvokeRequired Then
            Me.Invoke(New ReportImportCompletedInvoker(AddressOf ReportImportCompleted), New Object() {e})
            Exit Sub
        End If

        RefreshTimer.Stop()

        If e.CompletedType = ExportCompleteArg.CompleteType.Cancelled Then
            Me.logwind.Items.Add("Restore process was canceled.")
        ElseIf e.CompletedType = ExportCompleteArg.CompleteType.Error Then
            Me.logwind.Items.Add("Restore process was interrupted by an exception.")
        End If

        Dim errMsg As String = ""
        If e.LastError IsNot Nothing Then errMsg = e.LastError.ToString()
        Me.logwind.Items.Add(("Import " & e.CompletedType.ToString() & vbCrLf & errMsg).Trim)

        ClearOperationData(True)
    End Sub

    Private Sub mb_ImportProgressChanged(ByVal sender As Object, ByVal e As ImportProgressArg)
        ReportImportProgress(e)
    End Sub

    Private Delegate Sub ReportImportProgressInvoker(ByVal e As ImportProgressArg)

    Private Sub ReportImportProgress(ByVal e As ImportProgressArg)
        If Not HighTimeForGuiRefresh AndAlso e.PercentageCompleted < 99 Then Exit Sub

        If Me.InvokeRequired Then
            Me.Invoke(New ReportImportProgressInvoker(AddressOf ReportImportProgress), New Object() {e})
            Exit Sub
        End If

        ProgressBar1.Value = e.PercentageCompleted
        Me.Text = "Progress " + e.PercentageCompleted.ToString() + "%"

        HighTimeForGuiRefresh = False
    End Sub

    Private Sub ClearOperationData(ByVal ContinueWithResetButtons As Boolean)
        If Not mb Is Nothing Then
            If cpt = CurrentProcessType.Export Then
                RemoveHandler mb.ExportProgressChanged, AddressOf mb_ExportProgressChanged
                RemoveHandler mb.ExportCompleted, AddressOf mb_ExportCompleted
            ElseIf cpt = CurrentProcessType.Import Then
                RemoveHandler mb.ImportProgressChanged, AddressOf mb_ImportProgressChanged
                RemoveHandler mb.ImportCompleted, AddressOf mb_ImportCompleted
            End If
            mb.Dispose()
            mb = Nothing
        End If
        cpt = CurrentProcessType.None
        HighTimeForGuiRefresh = True
        If ContinueWithResetButtons Then ResetButtons()
    End Sub

    Private Sub ResetButtons()
        butBackup.Enabled = (mb Is Nothing)
        butRestore.Enabled = (mb Is Nothing)
        btCancel.Enabled = Not (mb Is Nothing)
    End Sub

    Private Sub butRunQuery_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles butRunQuery.Click

        Dim dbConnection As MySqlConnectionStringBuilder = New MySqlConnectionStringBuilder(DoConnectionString())
        Dim conn1 As New MySqlConnection(dbConnection.ConnectionString)
        Dim myCommand As MySqlCommand = Nothing
        Dim sql As String = Me.txQuery.Text

        Dim result As Integer = 0

        Try
            If conn1.State = ConnectionState.Closed Then
                conn1.Open()
            End If

            If Me.rdInsert.Checked = True Then
                ''We run an insert command

                myCommand = New MySqlCommand(sql, conn1)
                result = myCommand.ExecuteNonQuery()
                MsgBox("Query result code: " & result.ToString)

            Else

                ''We get some result
                Dim dataQuery As MySqlDataAdapter = New MySqlDataAdapter(sql, conn1)
                Dim ds As New DataTable()

                dataQuery.Fill(ds)

                Me.DataGridView1.DataSource = ds
                dataQuery.Dispose()

            End If

        Catch ex As MySqlException
            MsgBox(ex.Message & " (" & sql & ")", MsgBoxStyle.Exclamation, "Query Error!")
        Finally
            conn1.Close()
            conn1.Dispose()

            If myCommand IsNot Nothing Then
                myCommand.Dispose()
            End If

            dbConnection = Nothing
            sql = Nothing
        End Try
    End Sub
End Class
